<?php
require_once '../config/config.php';

if (!isLoggedIn()) {
    redirect('../index.php');
}

$db = Database::getInstance()->getConnection();

// Mark as read
if (isset($_GET['read'])) {
    $id = intval($_GET['read']);
    $stmt = $db->prepare("UPDATE notifikasi SET is_read = 1 WHERE id = ? AND user_id = ?");
    $stmt->execute([$id, $_SESSION['user_id']]);
    redirect('index.php');
}

// Mark all as read
if (isset($_GET['read_all'])) {
    $stmt = $db->prepare("UPDATE notifikasi SET is_read = 1 WHERE (user_id = ? OR user_id IS NULL) AND is_read = 0");
    $stmt->execute([$_SESSION['user_id']]);
    redirect('index.php');
}

// Get notifications
$stmt = $db->prepare("SELECT * FROM notifikasi WHERE (user_id = ? OR user_id IS NULL) ORDER BY created_at DESC LIMIT 50");
$stmt->execute([$_SESSION['user_id']]);
$notifications = $stmt->fetchAll();

$unread_count = count(array_filter($notifications, fn($n) => $n['is_read'] == 0));

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notifikasi - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="index.php" class="nav-item active">
                <i class="fas fa-bell"></i>
                <span>Notifikasi</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-bell"></i> Notifikasi</h1>
                <p>Pemberitahuan dan peringatan sistem</p>
            </div>
            <?php if ($unread_count > 0): ?>
            <a href="?read_all=1" class="btn btn-primary">
                <i class="fas fa-check-double"></i> Tandai Semua Dibaca
            </a>
            <?php endif; ?>
        </header>

        <div class="content-section">
            <?php if (empty($notifications)): ?>
            <div class="empty">
                <i class="fas fa-bell-slash" style="font-size: 3rem; color: #ccc; margin-bottom: 20px;"></i>
                <p>Tidak ada notifikasi</p>
            </div>
            <?php else: ?>
            <div class="notifications-list">
                <?php foreach ($notifications as $notif): ?>
                <div class="notification-item <?php echo $notif['is_read'] == 0 ? 'unread' : ''; ?>" onclick="window.location='?read=<?php echo $notif['id']; ?>'">
                    <div class="notif-icon <?php echo $notif['tipe']; ?>">
                        <i class="fas fa-<?php 
                            echo $notif['tipe'] === 'warning' ? 'exclamation-triangle' : 
                                ($notif['tipe'] === 'danger' ? 'times-circle' : 
                                ($notif['tipe'] === 'success' ? 'check-circle' : 'info-circle')); 
                        ?>"></i>
                    </div>
                    <div class="notif-content">
                        <strong><?php echo htmlspecialchars($notif['judul']); ?></strong>
                        <p><?php echo htmlspecialchars($notif['pesan']); ?></p>
                        <small><?php echo formatDateTime($notif['created_at']); ?></small>
                    </div>
                    <?php if ($notif['is_read'] == 0): ?>
                    <div class="notif-unread-badge"></div>
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
    </main>

    <script src="../assets/js/main.js"></script>
    <style>
    .notifications-list {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }
    
    .notification-item {
        display: flex;
        gap: 15px;
        padding: 20px;
        background: white;
        border-radius: 10px;
        border-left: 4px solid #ddd;
        cursor: pointer;
        transition: all 0.3s;
        position: relative;
    }
    
    .notification-item:hover {
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        transform: translateX(5px);
    }
    
    .notification-item.unread {
        background: #f8f9fa;
        border-left-color: var(--primary);
    }
    
    .notif-unread-badge {
        position: absolute;
        top: 20px;
        right: 20px;
        width: 10px;
        height: 10px;
        background: var(--primary);
        border-radius: 50%;
    }
    </style>
</body>
</html>

